function [ exdeltap,M,np,errp ] = prdspl_aux_3( orig_delta,r,d1,d2,d3 )
%Output M(i,j,k,:) which expresses Nid1*Njd2*Nkd3 product on S^r_(d1+d2+d3)
%   By computing these quantities once, we won't have to compute it
%   everytime we want to multiply arbitrary splines over the same
%   partition. One problem is does have to be recomputed every time the
%   mesh is changed.

%Build the extended knot sequences.
[exdelta1,n1] = extpar(orig_delta,r,d1);
[exdelta2,n2] = extpar(orig_delta,r,d2);
[exdelta3,n3] = extpar(orig_delta,r,d3);
[exdeltap,np] = extpar(orig_delta,r,d1+d2+d3); %Knot sequence belonging to product

%Take product basis-many evenly spaced sample points spanning [a,b]
t = orig_delta(1,1):(orig_delta(1,size(orig_delta,2))-orig_delta(1,1))/np:orig_delta(1,size(orig_delta,2));
t=t';

%Compute M 
M = zeros(n1,n2,n3,np);
Merrp = zeros(n1,n2,n3);
Id1 = eye(n1); %For writing coeffs on std basis S^r,d1
Id2 = eye(n2); %For writing coeffs on std basis S^r,d2
Id3 = eye(n3); %For writing coeffs on std basis S^r_d3
for i=1:n1
    for j=1:n2
        for k=1:n3
        %Evaluate Nid1*Njd2*Nkd3 at the evenly spaced points
        val1 = sval2(d1,exdelta1,n1,Id1(i,:),t);
        val2 = sval2(d2,exdelta2,n2,Id2(j,:),t);
        val3 = sval2(d3,exdelta3,n3,Id3(k,:),t);

        valp = val1.*val2.*val3; %Compute the product
        %Find coeffs of product spline and error of fit
        [M(i,j,k,:),Merrp(i,j,k)] = lsqspl(d1+d2+d3,np,exdeltap,t,valp);
        end
    end
end

errp = Merrp;

end

